﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.IO;


namespace IPBL
{
    public static class ImageMath
    {

        /// <summary>
        /// جمع یا تفریق دو تصویر.
        /// پیکسل های متناظر دو تصویر را با هم جمع یا تفریق میکند و نتیجه را
        /// در اندازه مشترک دو تصویر، یا اجتماع ، یا با اندازه تصویر اول یا دوم ذخیره میکند
        /// </summary>
        /// <param name="sighn1">علامت تصویر اول، منفی یا خالی</param>
        /// <param name="filename1">آدرس فایل تصویر ورودی اول</param>
        /// <param name="sighn2">علامت تصویر دوم، منفی یا خالی</param>
        /// <param name="filename2">آدرس فایل تصویر ورودی دوم</param>
        /// <param name="addingType">اندازه تصویر خروجی:
        /// s : حداقل اندازه ممکن که مشترک بین دو تصویر باشد
        /// j : حداکثر اندازه تصویر ممکن، جاهای اظافی سیاه خواهند شد
        /// byfirst : همان اندازه تصویر اول
        /// by seccond : همان اندازه تصویر دوم</param>
        /// <returns>آدرس فایل خروجی تصویر،
        /// یا خطای برنامه</returns>
        //static public string add(string sighn1, string filename1, string sighn2, string filename2, string addingType)
        static public Bitmap add(string sighn1, Bitmap bmp1, string sighn2, Bitmap bmp2, string addingType)
        {
            //Bitmap bmp1 = new Bitmap(filename1);
            int width1 = bmp1.Width, height1 = bmp1.Height;
            //Bitmap bmp2 = new Bitmap(filename2);
            int width2 = bmp2.Width, height2 = bmp2.Height;

            int[, ,] image1 = Matris.Load.Matris3DFromeBMP(bmp1);
            int[, ,] image2 = Matris.Load.Matris3DFromeBMP(bmp2);
            int[, ,] newimage = null;

            int width = 0, height = 0;
            switch (addingType)
            {
                case "s":
                    {
                        width = width1 < width2 ? width1 : width2;
                        height = height1 < height2 ? height1 : height2;
                        newimage = new int[width, height, 3];
                        for (int i = 0; i < width; i++)
                        {
                            for (int j = 0; j < height; j++)
                            {
                                if (sighn1 == "-" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] - image2[i, j, 2];
                                }
                                else if (sighn1 == "-" && sighn2 == "")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] + image2[i, j, 2];
                                }
                                else if (sighn1 == "" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] - image2[i, j, 2];
                                }
                                else
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] + image2[i, j, 2];
                                }
                            }
                        }

                        Matris.Math.ApplyThreshold(ref newimage, width, height, 255, 0);

                        return Matris.Load.BMPfromeMatris3D(ref newimage, width, height);
                    }
                case "j":
                    {
                        int lwidth = width1 <= width2 ? width1 : width2;
                        int lheight = height1 <= height2 ? height1 : height2;
                        int hwidth = width1 >= width2 ? width1 : width2;
                        int biggerw = width1 > width2 ? 1 : 2;
                        int hheight = height1 >= height2 ? height1 : height2;
                        int biggerh = height1 > height2 ? 1 : 2;

                        newimage = new int[lwidth, lheight, 3];

                        for (int i = 0; i < lwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                if (sighn1 == "-" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = -image1[i,j,0] - image2[i,j,0];
                                    newimage[i, j, 1] = -image1[i,j,1] - image2[i,j,1];
                                    newimage[i, j, 2] = -image1[i,j,2]- image2[i,j,2];
                                }
                                if (sighn1 == "-" && sighn2 == "")
                                {
                                    newimage[i, j, 0] = -image1[i,j,0] + image2[i,j,0];
                                    newimage[i, j, 1] = -image1[i,j,1] + image2[i,j,1];
                                    newimage[i, j, 2] = -image1[i,j,2]+ image2[i,j,2];
                                }
                                if (sighn1 == "" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = image1[i,j,0] - image2[i,j,0];
                                    newimage[i, j, 1] = image1[i,j,1] - image2[i,j,1];
                                    newimage[i, j, 2] = image1[i,j,2]- image2[i,j,2];
                                }
                                else
                                {
                                    newimage[i, j, 0] = image1[i,j,0] + image2[i,j,0];
                                    newimage[i, j, 1] = image1[i,j,1] + image2[i,j,1];
                                    newimage[i, j, 2] = image1[i,j,2]+ image2[i,j,2];
                                }
                            }
                            for (int j = lheight; j < hheight; j++)
                            {
                                if (biggerh == 1)
                                {
                                    newimage[i, j, 0] = image1[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2];
                                }
                                else
                                {// if(biggerh == 2 )
                                    newimage[i, j, 0] = image2[i, j, 0];
                                    newimage[i, j, 1] = image2[i, j, 1];
                                    newimage[i, j, 2] = image2[i, j, 2];
                                }
                            }
                        }
                        for (int i = lwidth; i < hwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                if (biggerw == 1)
                                {
                                    newimage[i, j, 0] = image1[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2];
                                }
                                else
                                {// if(biggerh == 2 )
                                    newimage[i, j, 0] = image2[i, j, 0];
                                    newimage[i, j, 1] = image2[i, j, 1];
                                    newimage[i, j, 2] = image2[i, j, 2];
                                }
                            }
                            for (int j = lheight; j < hheight; j++)
                            {
                                if (biggerh == 1 && biggerw == 1)
                                {
                                    newimage[i, j, 0] = image1[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2];
                                }
                                else if (biggerh == 2 && biggerw == 2)
                                {// if(biggerh == 2 )
                                    newimage[i, j, 0] = image2[i, j, 0];
                                    newimage[i, j, 1] = image2[i, j, 1];
                                    newimage[i, j, 2] = image2[i, j, 2];
                                }
                                else
                                {
                                    newimage[i, j, 0] = 0;
                                    newimage[i, j, 1] = 0;
                                    newimage[i, j, 2] = 0;
                                }
                            }
                        }

                        Matris.Math.ApplyThreshold(ref newimage, lwidth, lheight, 255, 0);

                        return Matris.Load.BMPfromeMatris3D(ref newimage, lwidth, lheight);
                    }
                case "byfirst":
                    {
                        int lwidth = 0, hwidth = 0, lheight = 0, hheight = 0;
                        if (width1 <= width2)
                            hwidth = lwidth = width1;
                        else
                        {
                            lwidth = width2;
                            hwidth = width1;
                        }
                        if (height1 <= height2)
                            lheight = hheight = height1;
                        else
                        {
                            lheight = height2;
                            hheight = height1;
                        }

                        newimage = new int[lwidth, lheight, 3];

                        for (int i = 0; i < lwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                if (sighn1 == "-" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] - image2[i, j, 2];
                                }
                                if (sighn1 == "-" && sighn2 == "")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] + image2[i, j, 2];
                                }
                                if (sighn1 == "" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] - image2[i, j, 2];
                                }
                                else
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] + image2[i, j, 2];
                                }
                            }
                            for (int j = lheight; j < hheight; j++)
                            {
                                newimage[i, j, 0] = image1[i, j, 0];
                                newimage[i, j, 1] = image1[i, j, 1];
                                newimage[i, j, 2] = image1[i, j, 2];
                            }
                        }
                        for (int i = lwidth; i < hwidth; i++)
                            for (int j = 0; j < lheight; j++)
                            {
                                newimage[i, j, 0] = image1[i, j, 0];
                                newimage[i, j, 1] = image1[i, j, 1];
                                newimage[i, j, 2] = image1[i, j, 2];
                            }

                        Matris.Math.ApplyThreshold(ref newimage, lwidth, lheight, 255, 0);

                        return Matris.Load.BMPfromeMatris3D(ref newimage, lwidth, lheight);
                    }
                case "byseccond":
                    {
                        int lwidth = 0, hwidth = 0, lheight = 0, hheight = 0;
                        if (width2 <= width1)
                            hwidth = lwidth = width2;
                        else
                        {
                            lwidth = width1;
                            hwidth = width2;
                        }
                        if (height2 <= height1)
                            lheight = hheight = height2;
                        else
                        {
                            lheight = height1;
                            hheight = height2;
                        }

                        newimage = new int[lwidth, lheight, 3];

                        for (int i = 0; i < lwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                if (sighn1 == "-" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] - image2[i, j, 2];
                                }
                                if (sighn1 == "-" && sighn2 == "")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] + image2[i, j, 2];
                                }
                                if (sighn1 == "" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] - image2[i, j, 2];
                                }
                                else
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] + image2[i, j, 2];
                                }
                            }
                            for (int j = lheight; j < hheight; j++)
                            {
                                newimage[i, j, 0] = image2[i, j, 0];
                                newimage[i, j, 1] = image2[i, j, 1];
                                newimage[i, j, 2] = image2[i, j, 2];
                            }
                        }
                        for (int i = lwidth; i < hwidth; i++)
                            for (int j = 0; j < lheight; j++)
                            {
                                newimage[i, j, 0] = image2[i, j, 0];
                                newimage[i, j, 1] = image2[i, j, 1];
                                newimage[i, j, 2] = image2[i, j, 2];
                            }

                        Matris.Math.ApplyThreshold(ref newimage, lwidth, lheight, 255, 0);

                        return Matris.Load.BMPfromeMatris3D(ref newimage, lwidth, lheight);
                    }
                default: //return "ERRORE : args dosnt support!";
                    return null;
            }//switch addtype

        }
        static public int[,,] Add(string sighn1, Bitmap bmp1, string sighn2, Bitmap bmp2, string addingType)
        {
            //Bitmap bmp1 = new Bitmap(filename1);
            int width1 = bmp1.Width, height1 = bmp1.Height;
            //Bitmap bmp2 = new Bitmap(filename2);
            int width2 = bmp2.Width, height2 = bmp2.Height;

            int[, ,] image1 = Matris.Load.Matris3DFromeBMP(bmp1);
            int[, ,] image2 = Matris.Load.Matris3DFromeBMP(bmp2);

            return Add(sighn1, ref image1, width1, height1, sighn2, ref image2, width2, height2, addingType);
        }//add
        static public int[, ,] Add(
            string sighn1, ref int[, ,] image1, int width1, int height1,
            string sighn2, ref int[, ,] image2, int width2, int height2,
            string addingType)
        {
            int[, ,] newimage = null;

            int width = 0, height = 0;
            switch (addingType)
            {
                case "s":
                    {
                        width = width1 < width2 ? width1 : width2;
                        height = height1 < height2 ? height1 : height2;
                        newimage = new int[width, height, 3];
                        for (int i = 0; i < width; i++)
                        {
                            for (int j = 0; j < height; j++)
                            {
                                if (sighn1 == "-" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] - image2[i, j, 2];
                                }
                                else if (sighn1 == "-" && sighn2 == "")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] + image2[i, j, 2];
                                }
                                else if (sighn1 == "" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] - image2[i, j, 2];
                                }
                                else
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] + image2[i, j, 2];
                                }
                            }
                        }
                        Matris.Math.ApplyThreshold(ref newimage, width, height, 255, 0);
                        return newimage;
                    }
                case "j":
                    {
                        int lwidth = width1 <= width2 ? width1 : width2;
                        int lheight = height1 <= height2 ? height1 : height2;
                        int hwidth = width1 >= width2 ? width1 : width2;
                        int biggerw = width1 > width2 ? 1 : 2;
                        int hheight = height1 >= height2 ? height1 : height2;
                        int biggerh = height1 > height2 ? 1 : 2;

                        newimage = new int[lwidth, lheight, 3];

                        for (int i = 0; i < lwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                if (sighn1 == "-" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] - image2[i, j, 2];
                                }
                                if (sighn1 == "-" && sighn2 == "")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] + image2[i, j, 2];
                                }
                                if (sighn1 == "" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] - image2[i, j, 2];
                                }
                                else
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] + image2[i, j, 2];
                                }
                            }
                            for (int j = lheight; j < hheight; j++)
                            {
                                if (biggerh == 1)
                                {
                                    newimage[i, j, 0] = image1[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2];
                                }
                                else
                                {// if(biggerh == 2 )
                                    newimage[i, j, 0] = image2[i, j, 0];
                                    newimage[i, j, 1] = image2[i, j, 1];
                                    newimage[i, j, 2] = image2[i, j, 2];
                                }
                            }
                        }
                        for (int i = lwidth; i < hwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                if (biggerw == 1)
                                {
                                    newimage[i, j, 0] = image1[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2];
                                }
                                else
                                {// if(biggerh == 2 )
                                    newimage[i, j, 0] = image2[i, j, 0];
                                    newimage[i, j, 1] = image2[i, j, 1];
                                    newimage[i, j, 2] = image2[i, j, 2];
                                }
                            }
                            for (int j = lheight; j < hheight; j++)
                            {
                                if (biggerh == 1 && biggerw == 1)
                                {
                                    newimage[i, j, 0] = image1[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2];
                                }
                                else if (biggerh == 2 && biggerw == 2)
                                {// if(biggerh == 2 )
                                    newimage[i, j, 0] = image2[i, j, 0];
                                    newimage[i, j, 1] = image2[i, j, 1];
                                    newimage[i, j, 2] = image2[i, j, 2];
                                }
                                else
                                {
                                    newimage[i, j, 0] = 0;
                                    newimage[i, j, 1] = 0;
                                    newimage[i, j, 2] = 0;
                                }
                            }
                        }
                        Matris.Math.ApplyThreshold(ref newimage, lwidth, lheight, 255, 0);
                        return newimage;
                    }
                case "byfirst":
                    {
                        int lwidth = 0, hwidth = 0, lheight = 0, hheight = 0;
                        if (width1 <= width2)
                            hwidth = lwidth = width1;
                        else
                        {
                            lwidth = width2;
                            hwidth = width1;
                        }
                        if (height1 <= height2)
                            lheight = hheight = height1;
                        else
                        {
                            lheight = height2;
                            hheight = height1;
                        }

                        newimage = new int[lwidth, lheight, 3];

                        for (int i = 0; i < lwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                if (sighn1 == "-" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] - image2[i, j, 2];
                                }
                                if (sighn1 == "-" && sighn2 == "")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] + image2[i, j, 2];
                                }
                                if (sighn1 == "" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] - image2[i, j, 2];
                                }
                                else
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] + image2[i, j, 2];
                                }
                            }
                            for (int j = lheight; j < hheight; j++)
                            {
                                newimage[i, j, 0] = image1[i, j, 0];
                                newimage[i, j, 1] = image1[i, j, 1];
                                newimage[i, j, 2] = image1[i, j, 2];
                            }
                        }
                        for (int i = lwidth; i < hwidth; i++)
                            for (int j = 0; j < lheight; j++)
                            {
                                newimage[i, j, 0] = image1[i, j, 0];
                                newimage[i, j, 1] = image1[i, j, 1];
                                newimage[i, j, 2] = image1[i, j, 2];
                            }
                        Matris.Math.ApplyThreshold(ref newimage, lwidth, lheight, 255, 0);
                        return newimage;
                    }
                case "byseccond":
                    {
                        int lwidth = 0, hwidth = 0, lheight = 0, hheight = 0;
                        if (width2 <= width1)
                            hwidth = lwidth = width2;
                        else
                        {
                            lwidth = width1;
                            hwidth = width2;
                        }
                        if (height2 <= height1)
                            lheight = hheight = height2;
                        else
                        {
                            lheight = height1;
                            hheight = height2;
                        }

                        newimage = new int[lwidth, lheight, 3];

                        for (int i = 0; i < lwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                if (sighn1 == "-" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] - image2[i, j, 2];
                                }
                                if (sighn1 == "-" && sighn2 == "")
                                {
                                    newimage[i, j, 0] = -image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = -image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = -image1[i, j, 2] + image2[i, j, 2];
                                }
                                if (sighn1 == "" && sighn2 == "-")
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] - image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] - image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] - image2[i, j, 2];
                                }
                                else
                                {
                                    newimage[i, j, 0] = image1[i, j, 0] + image2[i, j, 0];
                                    newimage[i, j, 1] = image1[i, j, 1] + image2[i, j, 1];
                                    newimage[i, j, 2] = image1[i, j, 2] + image2[i, j, 2];
                                }
                            }
                            for (int j = lheight; j < hheight; j++)
                            {
                                newimage[i, j, 0] = image2[i, j, 0];
                                newimage[i, j, 1] = image2[i, j, 1];
                                newimage[i, j, 2] = image2[i, j, 2];
                            }
                        }
                        for (int i = lwidth; i < hwidth; i++)
                            for (int j = 0; j < lheight; j++)
                            {
                                newimage[i, j, 0] = image2[i, j, 0];
                                newimage[i, j, 1] = image2[i, j, 1];
                                newimage[i, j, 2] = image2[i, j, 2];
                            }
                        Matris.Math.ApplyThreshold(ref newimage, lwidth, lheight, 255, 0);
                        return newimage;
                    }
                default: //return "ERRORE : args dosnt support!";
                    return null;
            }//switch addtype

        }//add
        /// <summary>
        /// مکمل گیری از تصویر
        /// </summary>
        public static Bitmap Complement(Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap newbmp = new Bitmap(width, height);
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    newbmp.SetPixel(i, j, Color.FromArgb(
                        255 - c.R, 255 - c.G, 255 - c.B));
                }
            }
            return newbmp;
        }
        public static int[,,] ComplementMatris3D(ref int [,,]image,int width,int height)
        {
            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                {
                    image[i, j, 0] = 255 - image[i, j, 0];
                    image[i, j, 1] = 255 - image[i, j, 1];
                    image[i, j, 2] = 255 - image[i, j, 2];
                }
            return image;
        }

        /// <summary>
        /// میانگین گیری از دو تصویر
        /// </summary>
        /// <param name="filename1">آدرس فایل تصویر ورودی اول</param>
        /// <param name="filename2">آدرس فایل تصویر ورودی دوم</param>
        /// <param name="averagingType">اندازه تصویر خروجی:
        /// s : حداقل اندازه ممکن که مشترک بین دو تصویر باشد
        /// j : حداکثر اندازه تصویر ممکن، جاهای اظافی سیاه خواهند شد
        /// byfirst : همان اندازه تصویر اول
        /// by seccond : همان اندازه تصویر دوم</param>
        /// <returns>آدرس فایل خروجی تصویر،
        /// یا خطای برنامه</returns>
        public static Bitmap average(ref Bitmap bmp1, ref Bitmap bmp2, string averagingType)
        {
            int width1 = bmp1.Width, height1 = bmp1.Height;
            int width2 = bmp2.Width, height2 = bmp2.Height;
            Bitmap bmpnew = new Bitmap(1,1);

            int width = 0, height = 0;
            switch (averagingType)
            {
                case "s":
                    {
                        width = width1 < width2 ? width1 : width2;
                        height = height1 < height2 ? height1 : height2;
                        bmpnew = new Bitmap(width, height);
                        for (int i = 0; i < width; i++)
                        {
                            for (int j = 0; j < height; j++)
                            {
                                Color c1 = bmp1.GetPixel(i, j);
                                Color c2 = bmp2.GetPixel(i, j);
                                bmpnew.SetPixel(i, j, Color.FromArgb((c1.R + c2.R) / 2, (c1.G + c2.G) / 2, (c1.B + c2.B) / 2));
                            }
                        }
                        break;
                    }
                case "j":
                    {
                        int lwidth = width1 <= width2 ? width1 : width2;
                        int lheight = height1 <= height2 ? height1 : height2;
                        int hwidth = width1 >= width2 ? width1 : width2;
                        int biggerw = width1 > width2 ? 1 : 2;
                        int hheight = height1 >= height2 ? height1 : height2;
                        int biggerh = height1 > height2 ? 1 : 2;

                        bmpnew = new Bitmap(hwidth, hheight);

                        for (int i = 0; i < lwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                Color c1 = bmp1.GetPixel(i, j);
                                Color c2 = bmp2.GetPixel(i, j);
                                bmpnew.SetPixel(i, j, Color.FromArgb((c1.R + c2.R) / 2, (c1.G + c2.G) / 2, (c1.B + c2.B) / 2));
                            }
                            for (int j = lheight; j < hheight; j++)
                            {
                                if (biggerh == 1)
                                    bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));
                                else// if(biggerh == 2 )
                                    bmpnew.SetPixel(i, j, bmp2.GetPixel(i, j));
                            }
                        }
                        for (int i = lwidth; i < hwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                if (biggerw == 1)
                                    bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));
                                else// if(biggerw == 2 )
                                    bmpnew.SetPixel(i, j, bmp2.GetPixel(i, j));
                            }
                            for (int j = lheight; j < hheight; j++)
                            {
                                if (biggerh == 1 && biggerw == 1)
                                    bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));
                                else if (biggerh == 2 && biggerw == 2)
                                    bmpnew.SetPixel(i, j, bmp2.GetPixel(i, j));
                                else
                                    bmpnew.SetPixel(i, j, Color.Black);
                            }
                        }
                        break;
                    }
                case "byfirst":
                    {
                        int lwidth = 0, hwidth = 0, lheight = 0, hheight = 0;
                        if (width1 <= width2)
                            hwidth = lwidth = width1;
                        else
                        {
                            lwidth = width2;
                            hwidth = width1;
                        }
                        if (height1 <= height2)
                            lheight = hheight = height1;
                        else
                        {
                            lheight = height2;
                            hheight = height1;
                        }

                        bmpnew = new Bitmap(width1, height1);

                        for (int i = 0; i < lwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                Color c1 = bmp1.GetPixel(i, j);
                                Color c2 = bmp2.GetPixel(i, j);
                                bmpnew.SetPixel(i, j, Color.FromArgb((c1.R + c2.R) / 2, (c1.G + c2.G) / 2, (c1.B + c2.B) / 2));
                            }
                            for (int j = lheight; j < hheight; j++)
                                bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));
                        }
                        for (int i = lwidth; i < hwidth; i++)
                            for (int j = 0; j < lheight; j++)
                                bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));
                        break;
                    }
                case "byseccond":
                    {
                        int lwidth = 0, hwidth = 0, lheight = 0, hheight = 0;
                        if (width2 <= width1)
                            hwidth = lwidth = width2;
                        else
                        {
                            lwidth = width1;
                            hwidth = width2;
                        }
                        if (height2 <= height1)
                            lheight = hheight = height2;
                        else
                        {
                            lheight = height1;
                            hheight = height2;
                        }

                        bmpnew = new Bitmap(width2, height2);

                        for (int i = 0; i < lwidth; i++)
                        {
                            for (int j = 0; j < lheight; j++)
                            {
                                Color c1 = bmp1.GetPixel(i, j);
                                Color c2 = bmp2.GetPixel(i, j);
                                bmpnew.SetPixel(i, j, Color.FromArgb((c1.R + c2.R) / 2, (c1.G + c2.G) / 2, (c1.B + c2.B) / 2));
                            }
                            for (int j = lheight; j < hheight; j++)
                                bmpnew.SetPixel(i, j, bmp2.GetPixel(i, j));
                        }
                        for (int i = lwidth; i < hwidth; i++)
                            for (int j = 0; j < lheight; j++)
                                bmpnew.SetPixel(i, j, bmp2.GetPixel(i, j));
                        break;
                    }
            }

            return bmpnew;
        }//average
        public static Bitmap Mult(ref Bitmap image, double mul)
        {
            int[, ,] matris = Matris.Load.Matris3DFromeBMP_(ref image);
            Matris.Math.mull(ref matris, image.Width, image.Height, mul);
            Matris.Math.ApplyThreshold(ref matris, image.Width, image.Height, 255, 0);
            return Matris.Load.BMPfromeMatris3D(ref matris, image.Width, image.Height);
        }
        public static Bitmap And(ref Bitmap image1,ref Bitmap image2, int threshold)
        {
            int width = Math.Min(image1.Width, image2.Width), height = Math.Min(image1.Height, image2.Height);
            Bitmap newimage = new Bitmap(width, height);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c1 = image1.GetPixel(i, j);
                    int image1v = (c1.R + c1.G + c1.B) / 3;
                    Color c2 = image2.GetPixel(i, j);
                    int image2v = (c2.R + c2.G + c2.B) / 3;
                    int isedge = image1v >= threshold ? image2v >= threshold ? (image1v + image2v) / 2 : 0 : 0;
                    newimage.SetPixel(i, j, Color.FromArgb(isedge, isedge, isedge));
                }
            }

            return newimage;
        }

        /// <summary>
        /// تابع نگاشت لگاریتم
        /// </summary>
        public static Bitmap Logarithm(Bitmap bmp, int C_)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);

                    int cr=c.R, cg=c.G, cb=c.B;

                    cr = C_ * Convert.ToInt16(Math.Log10(1+cr));
                    cg = C_ * Convert.ToInt16(Math.Log10(1+cg));
                    cb = C_ * Convert.ToInt16(Math.Log10(1+cb));

                    cr = cr < 0 ? 0 : cr > 255 ? 255 : cr;
                    cg = cg < 0 ? 0 : cg > 255 ? 255 : cg;
                    cb = cb < 0 ? 0 : cb > 255 ? 255 : cb;

                    bmpnew.SetPixel(i, j, Color.FromArgb(cr, cg, cb));
                }
            }

            return bmpnew;
        }
        public static Bitmap Logarithm(Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            //finding C_
            int R = 0;
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                { Color c = bmp.GetPixel(i, j); R = c.R > R ? c.R : c.G > R ? c.G : c.B > R ? c.B : R; }
            int C_ = 255 / Convert.ToInt16(Math.Log10(1 + R));


            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);

                    int cr = c.R, cg = c.G, cb = c.B;

                    cr = C_ * Convert.ToInt16(Math.Log10(1 + cr));
                    cg = C_ * Convert.ToInt16(Math.Log10(1 + cg));
                    cb = C_ * Convert.ToInt16(Math.Log10(1 + cb));

                    cr = cr < 0 ? 0 : cr > 255 ? 255 : cr;
                    cg = cg < 0 ? 0 : cg > 255 ? 255 : cg;
                    cb = cb < 0 ? 0 : cb > 255 ? 255 : cb;

                    bmpnew.SetPixel(i, j, Color.FromArgb(cr, cg, cb));
                }
            }

            return bmpnew;
        }//log
        public static Bitmap Exponential(Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            //finding C_
            int R = 0;
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                { Color c = bmp.GetPixel(i, j); R = c.R > R ? c.R : c.G > R ? c.G : c.B > R ? c.B : R; }
            double C_ = 255 / Math.Log10(1 + R);


            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);

                    Int64 cr = c.R, cg = c.G, cb = c.B;

                    cr = Convert.ToInt64(C_ * (Math.Pow(1.1, cr) - 1));
                    cg = Convert.ToInt64(C_ * (Math.Pow(1.1, cg) - 1));
                    cb = Convert.ToInt64(C_ * (Math.Pow(1.1, cb) - 1));

                    cr = cr < 0 ? 0 : cr > 255 ? 255 : cr;
                    cg = cg < 0 ? 0 : cg > 255 ? 255 : cg;
                    cb = cb < 0 ? 0 : cb > 255 ? 255 : cb;

                    bmpnew.SetPixel(i, j, Color.FromArgb(Convert.ToInt16(cr), Convert.ToInt16(cg), Convert.ToInt16(cb)));
                }
            }

            return bmpnew;
        }//exp

        //public static string hiseq(string filename)
        public static Bitmap histeq(string filename)
        {
            //first convert photo to Gray
            Bitmap bmp = new Bitmap(filename);
            bmp = Filters.rgb2gray(ref bmp, "avg");

            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            int MAXCOLORS = 255 * 255 * 255;
            int[] hist = new int[MAXCOLORS + 1];
            int L = 0;
            int N = width * height;
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    int index = c.R * c.G * c.B;
                    if (hist[index] == 0)
                        L++;
                    hist[index]++;
                }
            }
            int[] histCum = new int[MAXCOLORS + 1];
            for (int i = 1; i <= MAXCOLORS; i++)
                histCum[i] += histCum[i - 1] + hist[i];
            int[] eqHist = new int[MAXCOLORS + 1];
            for (int i = 1; i <= MAXCOLORS; i++)
                eqHist[i] = Convert.ToInt16(Math.Truncate(Convert.ToDouble(((L * histCum[i]) - N) / N)));

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    int index = c.R * c.G * c.B;
                    bmpnew.SetPixel(i, j, Color.FromArgb(eqHist[index], eqHist[index], eqHist[index]));
                }
            }

            //string newfilename = filename.Replace(".bmp", "_histeq.bmp");
            //bmpnew.Save(newfilename);

            bmp.Dispose();
            //bmpnew.Dispose();

            //return newfilename;
            return bmpnew;
        }

        public static Bitmap HoughLines(Bitmap image)
        {
            int width = image.Width, height = image.Height;
            //int[, ,] imageMatris = Matris.Load.Matris3DFromeBMP(image);

            double MaxRadious = Math.Sqrt(Math.Pow(width, 2) + Math.Pow(height, 2));
            double MaxTeta = 180;

            //int[, ,] HoughMatris = new int[Convert.ToInt16(MaxRadious), Convert.ToInt16(MaxTeta), 3];
            Bitmap HoughImage = new Bitmap(Convert.ToInt16(MaxRadious) + 1, Convert.ToInt16(MaxTeta) + 1);

            int centerX=width/2,centerY=height/2;
            int HcenterX = Convert.ToInt16(MaxRadious / 2), HcenterY = Convert.ToInt16(MaxTeta / 2);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    int x = i - centerX, y = centerY - j;
                    
                    int radius = Convert.ToInt16(Math.Sqrt(x * x + y * y));
                    int teta = Convert.ToInt16(Math.Atan(radius) * 90);

                    Color c = image.GetPixel(i, j);
                    Color c_ = HoughImage.GetPixel(radius, teta);
                    int r = c.R + c_.R, g = c.G + c_.G, b = c.B + c_.B;
                    r = r > 255 ? 255 : r < 0 ? 0 : r; g = g > 255 ? 255 : g < 0 ? 0 : g; b = b > 255 ? 255 : b < 0 ? 0 : b;

                    HoughImage.SetPixel(radius, teta, Color.FromArgb(r, g, b));
                }
            }

            //image.Dispose();
            //HoughImage.Dispose();

            return HoughImage;
        }
    }//class imageMath
}
